﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Printing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

namespace SpiderLog
{
    public partial class Wykresy : Form
    {

        public Wykresy()
        {
            InitializeComponent();
        }

        private void bt_refresh_Click(object sender, EventArgs e)
        {

        }

        private void Wykresy_Load(object sender, EventArgs e)
        {
            //TypWykresu.Items.AddRange(Enum.GetNames(typeof(SeriesChartType)));  // <- Tak można dodać wszystkie typy wykresów
            // TypWykresu.Items.Remove("Column"); // Niektóre typy jednak nie będą działać, więc należy je tutaj ukryć.
            TypWykresu.Items.Add("Line"); // Ja jednak wolę dodać ręcznie tylko kilka
            TypWykresu.Items.Add("Point");
            TypWykresu.Items.Add("Area");
            TypWykresu.Items.Add("RangeColumn");
        }

        private void TypWykresu_SelectedIndexChanged(object sender, EventArgs e) // Przypisanie typu wykresu po zmianie do każdej serii danych
        {
          chart1.Series["Temp. EGT"].ChartType = (SeriesChartType)Enum.Parse(typeof(SeriesChartType), TypWykresu.Text);
          chart1.Series["Temp. CHT"].ChartType = (SeriesChartType)Enum.Parse(typeof(SeriesChartType), TypWykresu.Text);
          chart1.Series["RPM"].ChartType = (SeriesChartType)Enum.Parse(typeof(SeriesChartType), TypWykresu.Text);
        }

        private void bt_drukuj_Click(object sender, EventArgs e)
        {
            chart1.Printing.PrintDocument = new PrintDocument();
            chart1.Printing.PrintDocument.PrintPage += new PrintPageEventHandler(Ustawienia_stronyWydruku);
            chart1.Printing.PrintDocument.DefaultPageSettings.Landscape = true;
            chart1.Printing.PrintPreview();
        }

        private void Ustawienia_stronyWydruku(object sender, PrintPageEventArgs ev)
        {
            Rectangle pozycja_na_wydruku = new Rectangle(ev.MarginBounds.X, ev.MarginBounds.Y, ev.MarginBounds.Width, ev.MarginBounds.Height);
            chart1.Printing.PrintPaint(ev.Graphics, pozycja_na_wydruku);

        }

Point? prevPosition = null;
ToolTip tooltip = new ToolTip();

private void chart1_MouseMove(object sender, MouseEventArgs e)
{
    var pos = e.Location;
    if (prevPosition.HasValue && pos == prevPosition.Value)
        return;
    tooltip.RemoveAll();
    prevPosition = pos;
    var results = chart1.HitTest(pos.X, pos.Y, false, ChartElementType.DataPoint);
    foreach (var result in results)
    {
        if (result.ChartElementType == ChartElementType.DataPoint)
        {
            var prop = result.Object as DataPoint;
            if (prop != null)
            {
                var pointXPixel = result.ChartArea.AxisX.ValueToPixelPosition(prop.XValue);
                var pointYPixel = result.ChartArea.AxisY.ValueToPixelPosition(prop.YValues[0]);

                if (Math.Abs(pos.X - pointXPixel) < 2 && Math.Abs(pos.Y - pointYPixel) < 2)
                {
                    tooltip.Show("Próbka=" + prop.XValue + ", Wartość=" + prop.YValues[0], this.chart1, pos.X, pos.Y - 15);
                }
            }
        }
    }

}

private void ResX_ValueChanged(object sender, EventArgs e)
{
    chart1.ChartAreas["seria1"].AxisX.Interval = (Double)ResX.Value;
}

private void ResY_ValueChanged(object sender, EventArgs e)
{
    chart1.ChartAreas["seria1"].AxisY.Interval = (Double)ResY.Value;
}

private void bt_zamknij_Click(object sender, EventArgs e)
{
    this.Close();
}
    }
}
