﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

namespace SpiderLog
{

    public partial class Spiderlog : Form
    {
        protected string FileName;
        bool zaladowany;
        public DataTable dt = new DataTable();  // DataTable, do którego załadujemy dane z pliku LOG       
        
        public Spiderlog()
        {
            InitializeComponent();
        }

        private void otwórzPlikLOGToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
            {
                dt.Rows.Clear();    
                dt.Columns.Clear();
                if (ReadFile(openFileDialog1.FileName)) { zaladowany = true; dataGridView1.DataSource = dt; pictureBox1.Visible = false; dataGridView1.Visible=true; }
            }
        }

        private bool ReadFile(string filename)
        {
            string[] Lines = File.ReadAllLines(filename);
            string[] Fields;
            if (Lines[0] != "AIR CONTROLLER LOG FILE Version 1.00")
            {
                MessageBox.Show("To nie jest poprawny nagłówek pliku log urządzenia SPIDER!");
            }
            else
            {
                statusStrip1.Items[0].Text = Lines[1];
                statusStrip1.Items[1].Text = Lines[2];
                Fields = Lines[3].Split(new char[] { ',' });
                int Cols = Fields.GetLength(0);

                // Najpierw utworzymy nagłówek z pliku zawary w zmiennej Fields[]
                for (int i = 0; i < Cols; i++)
                    dt.Columns.Add(Fields[i].ToUpper(), typeof(string));
                // Teraz wczytujemy dane do DataTable
                DataRow Row;
                for (int i = 4; i < Lines.GetLength(0); i++)
                {
                    Fields = Lines[i].Split(new char[] { ',' });
                    Row = dt.NewRow();
                    for (int f = 0; f < Cols; f++)
                        Row[f] = Fields[f];
                    dt.Rows.Add(Row);
                }
                return true;
            } return false;
        }

       private void wykres1ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (zaladowany) RysujWykres();
            else MessageBox.Show("Najpierw wczytaj plik log...");            
        }

       public void RysujWykres()
       {
           Wykresy wyk = new Wykresy();
           wyk.chart1.ChartAreas.Add("seria1");
           wyk.chart1.ChartAreas["seria1"].AxisX.Interval = 1;
           wyk.chart1.ChartAreas["seria1"].AxisX.Minimum = 1;
           wyk.chart1.ChartAreas["seria1"].AxisX.Maximum = dt.Rows.Count;
           wyk.chart1.ChartAreas["seria1"].AxisX.Title = "Próbka";
           wyk.chart1.ChartAreas["seria1"].AxisY.Title = "Temperatura";
           //wyk.chart1.ChartAreas["seria1"].AxisY.Interval = 50; //

               wyk.chart1.Series.Add("Temp. CHT"); // Dodajemuy serię danych CHT.
               wyk.chart1.Series["Temp. CHT"].ChartType = (SeriesChartType)Enum.Parse(typeof(SeriesChartType), "Line");
               wyk.chart1.Series["Temp. CHT"].Color = Color.Orange;  // Kolor linii wykresu CHT

               wyk.chart1.Series.Add("Temp. EGT"); // Dodajemuy serię danych EGT.
               wyk.chart1.Series["Temp. CHT"].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.Line;
               wyk.chart1.Series["Temp. EGT"].Color = Color.Red;  // Kolor linii wykresu EGT

               wyk.chart1.Series.Add("RPM"); // Dodajemuy serię danych RPM (obroty silnika).
               wyk.chart1.Series["Temp. CHT"].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.Line;
               wyk.chart1.Series["RPM"].Color = Color.Green;  // Kolor linii wykresu RPM

           for (int i = 0; i < dt.Rows.Count; i++)
           {
               if (SpiderLog.Properties.Settings.Default.czyEGT) wyk.chart1.Series["Temp. EGT"].Points.AddXY(i, dt.Rows[i][5]);
               if (SpiderLog.Properties.Settings.Default.czyCHT) wyk.chart1.Series["Temp. CHT"].Points.AddXY(i, dt.Rows[i][4]);
               if (SpiderLog.Properties.Settings.Default.czyRPM) wyk.chart1.Series["RPM"].Points.AddXY(i, dt.Rows[i][3]);
           }

           wyk.ShowDialog();
       }

       private void informacjeToolStripMenuItem_Click(object sender, EventArgs e)
       {
           AboutBox1 about = new AboutBox1();
           about.ShowDialog();
       }

       private void ustawieniaWykresuToolStripMenuItem_Click(object sender, EventArgs e)
       {
           ustawienia ustaw = new ustawienia();
           ustaw.ShowDialog();
       }

       private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
       {
           Application.Exit();
       }

       
    }
}
